/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration;

import com.james.tinkerscalibration.TinkersCalibrationArmorModifiers;
import com.james.tinkerscalibration.TinkersCalibrationConfig;
import com.james.tinkerscalibration.TinkersCalibrationWorldFeatures;
import com.james.tinkerscalibration.Utils;
import com.james.tinkerscalibration.contents.TinkersCalibrationBlocks;
import com.james.tinkerscalibration.contents.TinkersCalibrationFluids;
import com.james.tinkerscalibration.contents.TinkersCalibrationItems;
import com.james.tinkerscalibration.group.ModGroup;
import com.james.tinkerscalibration.hud.OvershieldHud;
import com.james.tinkerscalibration.hud.RangedDrawHud;
import com.james.tinkerscalibration.integration.BlueSkiesIntegration;
import com.james.tinkerscalibration.integration.MNAIntegration;
import com.james.tinkerscalibration.item.DryColdNoodles;
import com.james.tinkerscalibration.item.FiberGlass;
import com.james.tinkerscalibration.item.HardWheatRod;
import com.james.tinkerscalibration.item.HymonArrow;
import com.james.tinkerscalibration.item.WetSoftNoodles;
import com.james.tinkerscalibration.library.TinkersCalibrationLootModifiers;
import com.james.tinkerscalibration.tiers.DarkMatterTier;
import com.james.tinkerscalibration.tiers.FakeEndGobberTier;
import com.james.tinkerscalibration.tiers.FakeGobberTier;
import com.james.tinkerscalibration.tiers.FakeNetherGobberTier;
import com.james.tinkerscalibration.tiers.RedMatterTier;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="tinkerscalibration")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TinkersCalibration {
    public static final Logger logger = LogManager.getLogger((String)"tinkerscalibration");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "tinkerscalibration";
    public static final String GOBBERID = "gobber2";
    public static final DeferredRegister<Item> Items = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tinkerscalibration");
    public static RegistryObject<Item> Hymon_Arrow = Items.register("hymon_arrow", TinkersCalibration::register);

    public TinkersCalibration() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(TinkersCalibration::registerGUIOverlays);
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        TinkersCalibrationFluids.FLUIDS.register(bus);
        TinkersCalibrationBlocks.BLOCKS.register(bus);
        TinkersCalibrationItems.ITEMS.register(bus);
        TinkersCalibrationConfig.init();
        Utils.MODIFIERS.register(bus);
        Utils.PARTICLE_TYPES.register(bus);
        TinkersCalibrationWorldFeatures.CONFIGURED_FEATURES.register(bus);
        TinkersCalibrationWorldFeatures.PLACED_FEATURES.register(bus);
        TinkersCalibrationWorldFeatures.BLOCKS.register(bus);
        if (ModList.get().isLoaded("tinkers_thinking")) {
            TinkersCalibrationLootModifiers.init(bus);
            logger.info("Found Tinkers' Thinking, spaghetti initializing\u2026\u2026");
        }
        FiberGlass.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HardWheatRod.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        WetSoftNoodles.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        DryColdNoodles.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HymonArrow.ItemRegistry.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        Utils.RECIPE_SERIALIZERS.register(bus);
        TinkersCalibrationArmorModifiers.Init();
    }

    @SubscribeEvent
    public static void registerGUIOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("shield", OvershieldHud.HUD_SHIELD);
    }

    private void setup(FMLCommonSetupEvent event) {
        boolean un;
        boolean tw;
        boolean mn;
        boolean bs;
        boolean gb;
        boolean pe = ModList.get().isLoaded("projecte");
        if (pe) {
            logger.info("Found ProjectE, integration initializing\u2026\u2026");
            this.registerTier(RedMatterTier.instance, MODID, "redmatter");
            this.registerTier(DarkMatterTier.instance, MODID, "darkmatter");
        }
        if (!(gb = ModList.get().isLoaded(GOBBERID))) {
            this.registerTier(FakeGobberTier.instance, GOBBERID, "overworld_gobber");
            this.registerTier(FakeNetherGobberTier.instance, GOBBERID, "nether_gobber");
            this.registerTier(FakeEndGobberTier.instance, GOBBERID, "end_gobber");
        }
        if (bs = ModList.get().isLoaded("blue_skies")) {
            BlueSkiesIntegration.Init();
            logger.info("Found Blue Skies, integration initializing\u2026\u2026");
        }
        if (mn = ModList.get().isLoaded("mna")) {
            MNAIntegration.Init();
            logger.info("Found Mana and Artifice, integration initializing\u2026\u2026");
        }
        if (tw = ModList.get().isLoaded("twilightforest")) {
            TinkersCalibrationArmorModifiers.InitT();
            logger.info("Found Twilight Forest, armor integration initializing\u2026\u2026");
        }
        if (un = ModList.get().isLoaded("upgradednetherite")) {
            TinkersCalibrationArmorModifiers.InitN();
            logger.info("Found Upgraded Netherite, armor integration initializing\u2026\u2026");
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RangedDrawHud());
    }

    public void registerTier(Tier instance, String id, String name) {
        if (!TierSortingRegistry.isTierSorted((Tier)instance)) {
            if (!TierSortingRegistry.getSortedTiers().isEmpty()) {
                TierSortingRegistry.registerTier((Tier)instance, (ResourceLocation)new ResourceLocation(id + ":" + name), List.of(TierSortingRegistry.getSortedTiers().get(TierSortingRegistry.getSortedTiers().size())), List.of());
            } else {
                TierSortingRegistry.registerTier((Tier)instance, (ResourceLocation)new ResourceLocation(id + ":" + name), List.of(Tiers.NETHERITE), List.of());
            }
        }
    }

    public static Item register() {
        return new Item(new Item.Properties().m_41491_(ModGroup.itemGroup));
    }

    public static Logger getLogger() {
        return LOGGER;
    }
}

